<?php
require 'includes/auth_check.php';
require 'includes/header.php';

// Fetch stats
$total_users = $conn->query("SELECT COUNT(id) as count FROM users")->fetch_assoc()['count'];
$pending_withdrawals = $conn->query("SELECT COUNT(id) as count FROM withdrawals WHERE status = 'pending'")->fetch_assoc()['count'];
$total_earned = $conn->query("SELECT SUM(total_earnings) as sum FROM users")->fetch_assoc()['sum'];
$total_withdrawn = $conn->query("SELECT SUM(amount) as sum FROM withdrawals WHERE status = 'completed'")->fetch_assoc()['sum'];
?>
<header>
    <h1>Dashboard</h1>
</header>

<div class="dashboard-cards">
    <div class="card dashboard-card">
        <h3>Total Users</h3>
        <p><?= $total_users ?></p>
    </div>
    <div class="card dashboard-card">
        <h3>Pending Withdrawals</h3>
        <p><?= $pending_withdrawals ?></p>
    </div>
    <div class="card dashboard-card">
        <h3>Total Earned by Users</h3>
        <p><?= number_format($total_earned ?? 0, 2) ?> BD</p>
    </div>
    <div class="card dashboard-card">
        <h3>Total Withdrawn</h3>
        <p><?= number_format($total_withdrawn ?? 0, 2) ?> BD</p>
    </div>
</div>

<?php require 'includes/footer.php'; ?>