<?php
require 'includes/auth_check.php';
require 'includes/header.php';

// Handle settings update when form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // List of all settings that can be updated from the form
    $settings_to_update = [
        'ads_reward',
        'daily_ads_limit',
        'refer_bonus_percentage',
        'currency_symbol',
        'monetag_zone_id',
        'bot_username' // Added bot_username to the list
    ];

    // Prepare the SQL statement once for efficiency
    $stmt = $conn->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = ?");
    
    foreach ($settings_to_update as $key) {
        if (isset($_POST[$key])) {
            $value = trim($_POST[$key]);
            $stmt->bind_param("ss", $value, $key);
            $stmt->execute();
        }
    }
    
    $stmt->close();
    $message = "Settings updated successfully!";
}

// Fetch all current settings from the database to display in the form
$settings = [];
$result = $conn->query("SELECT * FROM settings");
while ($row = $result->fetch_assoc()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}
?>

<header>
    <h1>App Settings</h1>
</header>

<?php if(isset($message)): ?>
    <div class="alert" style="background-color: var(--success-color); color: white; padding: 15px; margin-bottom: 20px; border-radius: 5px;">
        <?= $message ?>
    </div>
<?php endif; ?>

<div class="card">
    <form method="post">
        <h3>Monetization Settings</h3>
        <div class="form-group">
            <label for="ads_reward">Ads Reward</label>
            <input type="number" step="0.01" id="ads_reward" name="ads_reward" value="<?= htmlspecialchars($settings['ads_reward'] ?? '') ?>" placeholder="e.g., 1.00">
        </div>
        <div class="form-group">
            <label for="daily_ads_limit">Daily Ads Limit</label>
            <input type="number" id="daily_ads_limit" name="daily_ads_limit" value="<?= htmlspecialchars($settings['daily_ads_limit'] ?? '') ?>" placeholder="e.g., 60">
        </div>
        <div class="form-group">
            <label for="refer_bonus_percentage">Refer Bonus (%)</label>
            <input type="number" id="refer_bonus_percentage" name="refer_bonus_percentage" value="<?= htmlspecialchars($settings['refer_bonus_percentage'] ?? '') ?>" placeholder="e.g., 5">
        </div>
        <div class="form-group">
            <label for="currency_symbol">Currency Symbol</label>
            <input type="text" id="currency_symbol" name="currency_symbol" value="<?= htmlspecialchars($settings['currency_symbol'] ?? 'BD') ?>">
        </div>
        
        <hr style="margin: 20px 0;">

        <h3>API & Integration Settings</h3>
        <div class="form-group">
            <label for="monetag_zone_id">Monetag Zone ID</label>
            <input type="text" id="monetag_zone_id" name="monetag_zone_id" value="<?= htmlspecialchars($settings['monetag_zone_id'] ?? '') ?>" placeholder="Enter your Monetag Zone ID">
        </div>
        
        <hr style="margin: 20px 0;">

        <h3>Bot Settings</h3>
        <div class="form-group">
            <label for="bot_username">Bot Username (without @)</label>
            <input type="text" id="bot_username" name="bot_username" value="<?= htmlspecialchars($settings['bot_username'] ?? 'Dev_Ariful_Start_Earning_bot') ?>" placeholder="Enter your bot's username">
        </div>
        
        <button type="submit" class="btn btn-primary">Save Settings</button>
    </form>
</div>

<?php require 'includes/footer.php'; ?>