<?php
require 'db_config.php';

// Allow cross-origin requests for development
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

$telegram_id = isset($_GET['telegram_id']) ? (int)$_GET['telegram_id'] : 0;
$first_name = isset($_GET['first_name']) ? trim($_GET['first_name']) : 'User';
$username = isset($_GET['username']) ? trim($_GET['username']) : null;

if ($telegram_id === 0) {
    echo json_encode(['error' => 'Invalid Telegram User ID.']);
    exit();
}

// Check if user's daily ad count needs reset
$today = date('Y-m-d');
$conn->query("UPDATE users SET ads_watched_today = 0 WHERE telegram_id = $telegram_id AND last_ad_watched_date < '$today'");

// Fetch user data
$stmt = $conn->prepare("SELECT * FROM users WHERE telegram_id = ?");
$stmt->bind_param("i", $telegram_id);
$stmt->execute();
$result = $stmt->get_result();

$user = null;
if ($result->num_rows > 0) {
    $user = $result->fetch_assoc();
} else {
    // Create new user if not exists
    $insert_stmt = $conn->prepare("INSERT INTO users (telegram_id, first_name, username, last_ad_watched_date) VALUES (?, ?, ?, ?)");
    $insert_stmt->bind_param("isss", $telegram_id, $first_name, $username, $today);
    if ($insert_stmt->execute()) {
        $stmt->execute();
        $user = $stmt->get_result()->fetch_assoc();
    }
}
$stmt->close();

if (!$user) {
     echo json_encode(['error' => 'Failed to retrieve or create user profile.']);
     exit();
}

// Fetch all settings
$settings = [];
$settings_result = $conn->query("SELECT setting_key, setting_value FROM settings");
while($row = $settings_result->fetch_assoc()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

// Fetch tasks
$tasks = [];
$tasks_result = $conn->query("SELECT id, title, link, reward FROM tasks WHERE is_active = 1");
while($row = $tasks_result->fetch_assoc()) {
    $tasks[] = $row;
}

// Fetch user's completed tasks
$completed_tasks = [];
$completed_stmt = $conn->prepare("SELECT task_id FROM user_completed_tasks WHERE user_telegram_id = ?");
$completed_stmt->bind_param("i", $telegram_id);
$completed_stmt->execute();
$completed_result = $completed_stmt->get_result();
while($row = $completed_result->fetch_assoc()) {
    $completed_tasks[] = $row['task_id'];
}
$completed_stmt->close();

$response = [
    'user' => $user,
    'settings' => $settings,
    'tasks' => $tasks,
    'completed_tasks' => $completed_tasks
];

echo json_encode($response);

$conn->close();
?>