<?php
// --- PHP Backend Part ---
if (isset($_GET['action'])) {
    // --- DATABASE CONNECTION (এখানে আপনার আসল তথ্য বসানো থাকবে) ---
    $servername = "localhost";
    $username = "codeworks_mini100"; // <-- আপনার cPanel ডাটাবেসের ইউজারনেয়াম দিন
    $password = "codeworks_mini100"; // <-- আপনার ডাটাবেসের পাসওয়ার্ড দিন
    $dbname = "codeworks_mini100";       // <-- আপনার ডাটাবেসের নাম দিন
    
    header("Content-Type: application/json; charset=UTF-8");
    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) { die(json_encode(['error'=>'DB Connection Failed'])); }
    $conn->set_charset("utf8mb4");

    // --- API ACTION: get_app_data ---
    if ($_GET['action'] === 'get_app_data') {
        $telegram_id = (int)($_GET['telegram_id'] ?? 0);
        $first_name = trim($_GET['first_name'] ?? 'User');
        $username = trim($_GET['username'] ?? '');
        $today = date('Y-m-d');
        
        $conn->query("UPDATE users SET ads_watched_today = 0 WHERE telegram_id = $telegram_id AND last_ad_watched_date < '$today'");
        
        $stmt = $conn->prepare("SELECT * FROM users WHERE telegram_id = ?");
        $stmt->bind_param("i", $telegram_id); $stmt->execute();
        $user = $stmt->get_result()->fetch_assoc();
        
        if (!$user) {
            $stmt = $conn->prepare("INSERT INTO users (telegram_id, first_name, username, last_ad_watched_date) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("isss", $telegram_id, $first_name, $username, $today);
            if($stmt->execute()){
                $stmt = $conn->prepare("SELECT * FROM users WHERE telegram_id = ?");
                $stmt->bind_param("i", $telegram_id); $stmt->execute();
                $user = $stmt->get_result()->fetch_assoc();
            }
        }
        
        $settings = []; $tasks = []; $completed_tasks = [];
        $result = $conn->query("SELECT setting_key, setting_value FROM settings");
        while($row = $result->fetch_assoc()){ $settings[$row['setting_key']] = $row['setting_value']; }
        
        $result = $conn->query("SELECT id, title, link, reward FROM tasks WHERE is_active = 1");
        while($row = $result->fetch_assoc()){ $tasks[] = $row; }
        
        $stmt = $conn->prepare("SELECT task_id FROM user_completed_tasks WHERE user_telegram_id = ?");
        $stmt->bind_param("i", $telegram_id); $stmt->execute();
        $result = $stmt->get_result();
        while($row = $result->fetch_assoc()){ $completed_tasks[] = (int)$row['task_id']; }
        
        echo json_encode(['user' => $user, 'settings' => $settings, 'tasks' => $tasks, 'completed_tasks' => $completed_tasks]);
    }

    // --- API ACTION: record_ad_watch ---
    if ($_GET['action'] === 'record_ad_watch') {
        $telegram_id = (int)($_GET['telegram_id'] ?? 0);
        if ($telegram_id > 0) {
            $reward = (float)$conn->query("SELECT setting_value FROM settings WHERE setting_key = 'ads_reward'")->fetch_assoc()['setting_value'];
            $today = date('Y-m-d');
            $conn->query("UPDATE users SET balance = balance + $reward, total_earnings = total_earnings + $reward, ads_watched_today = ads_watched_today + 1, last_ad_watched_date = '$today' WHERE telegram_id = $telegram_id");
            echo json_encode(['success' => true, 'message' => "Congratulations! Reward of {$reward} has been added."]);
        } else { echo json_encode(['success' => false, 'message' => "Invalid user."]); }
    }
    
    $conn->close();
    exit();
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, viewport-fit=cover">
    <title>Start Earning</title>
    <script src="https://telegram.org/js/telegram-web-app.js"></script>
    <script src='//libtl.com/sdk.js' data-zone='10080568' data-sdk='show_10080568'></script> <!-- Monetag SDK -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css"> <!-- Font Awesome for Icons -->
    <style>
        /* All necessary CSS is included here */
        :root { --primary-color: #4CAF50; --primary-light: #E8F5E9; --background-color: #f7f9fc; --card-bg-color: #ffffff; --text-color: #333; --text-light: #757575; --border-color: #e0e0e0; }
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif; margin: 0; background-color: var(--background-color); color: var(--text-color); }
        .app-container { max-width: 500px; margin: 0 auto; background-color: var(--card-bg-color); min-height: 100vh; display: flex; flex-direction: column; }
        #app-header { padding: 10px 15px; display: flex; justify-content: space-between; align-items: center; background: var(--card-bg-color); border-bottom: 1px solid var(--border-color); position: sticky; top: 0; z-index: 10; }
        .user-profile-header { display: flex; align-items: center; }
        .avatar { width: 40px; height: 40px; border-radius: 50%; margin-right: 12px; }
        #user-name { font-weight: 700; display: block; } #user-balance { color: var(--primary-color); font-size: 14px; font-weight: 500;}
        #app-title { font-weight: 700; font-size: 18px; }
        main { padding: 20px; flex-grow: 1; background-color: var(--background-color); }
        .card { background: var(--card-bg-color); padding: 20px; border-radius: 16px; box-shadow: 0 4px 20px rgba(0,0,0,0.07); margin-bottom: 20px; }
        .btn { display: flex; align-items:center; justify-content: center; gap: 8px; width: 100%; padding: 15px; border: none; background-color: var(--primary-color); color: white; font-size: 16px; font-weight: 700; border-radius: 12px; cursor: pointer; text-align: center; }
        .btn:disabled { background-color: #bdc3c7; cursor: not-allowed; }
        footer { position: sticky; bottom: 0; width: 100%; max-width: 500px; background: #fff; border-top: 1px solid var(--border-color); box-shadow: 0 -2px 10px rgba(0,0,0,0.05); }
        .bottom-nav { display: flex; justify-content: space-around; padding: 10px 0; }
        .nav-item { background: none; border: none; cursor: pointer; color: #999; font-size: 10px; text-align: center; flex-grow: 1; }
        .nav-item.active { color: var(--primary-color); }
        .page { display: none; } .page.active { display: block; animation: fadeIn 0.3s; }
        @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }
        /* Profile Page */
        .profile-card { text-align: center; } .profile-avatar { width: 90px; height: 90px; border-radius: 50%; border: 4px solid white; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
        .stat-item { display: flex; align-items: center; padding: 15px 10px; border-bottom: 1px solid var(--border-color); text-align: left; } .stat-item:last-child { border-bottom: none; }
        .stat-item i { font-size: 20px; color: var(--primary-color); width: 40px; text-align: center; } .stat-item .info { flex-grow: 1; margin-left: 15px; } .stat-item .info span { color: var(--text-light); } .stat-item .value { font-weight: 700; font-size: 16px; }
        .contact-btn { background: var(--primary-light) !important; color: var(--primary-color) !important; }
        /* Earn Page */
        .ad-task-card .btn { background-color: var(--primary-light); color: var(--primary-color); }
        .task-item { display: flex; justify-content: space-between; align-items: center; padding: 15px 0; border-bottom: 1px solid var(--border-color); } .task-item:last-child { border-bottom: none; }
        .task-info strong { font-weight: 500; } .task-info span { color: var(--primary-color); font-weight: 700; }
        .task-actions .btn { padding: 8px 12px; font-size: 14px; margin-left: 5px; border-radius: 8px; }
        .btn-join { background-color: #e3f2fd; color: #2196f3; } .btn-verify { background-color: var(--primary-color); } .btn-completed { background-color: #cccccc; }
    </style>
</head>
<body>
    <div class="app-container">
        <header id="app-header">
            <div class="user-profile-header">
                <img id="user-avatar" src="https://i.ibb.co/2811g2W/placeholder-avatar.png" alt="Avatar" class="avatar">
                <div><span id="user-name">Loading...</span><span id="user-balance">0.00 BD</span></div>
            </div>
            
        </header>
        <main id="main-content">
            <div class="loading card">Connecting and fetching your profile...</div>
            <div id="page-home" class="page"></div><div id="page-earn" class="page"></div><div id="page-withdraw" class="page"></div>
            <div id="page-profile" class="page"></div><div id="page-referral" class="page"></div>
        </main>
        <footer>
            <nav class="bottom-nav">
                <button data-page="home" class="nav-item active" onclick="navigateTo('home')">🏠<br>Home</button>
                <button data-page="earn" class="nav-item" onclick="navigateTo('earn')">💰<br>Earn</button>
                <button data-page="withdraw" class="nav-item" onclick="navigateTo('withdraw')">💸<br>Withdraw</button>
                <button data-page="profile" class="nav-item" onclick="navigateTo('profile')">👤<br>Profile</button>
            </nav>
        </footer>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', () => {
        const tg = window.Telegram.WebApp;
        tg.ready(); tg.expand();
        
        let appData = null;
        const telegramUser = tg.initDataUnsafe?.user;

        async function loadAppData(showLoading = true) {
            if (showLoading) document.querySelector('.loading.card').style.display = 'block';
            if (!telegramUser) { /* ... error handling ... */ return false; }
            const apiUrl = `?action=get_app_data&telegram_id=${telegramUser.id}&first_name=${encodeURIComponent(telegramUser.first_name)}&username=${telegramUser.username || ''}`;
            try {
                const response = await fetch(apiUrl);
                if (!response.ok) throw new Error(`Server Error: ${response.status}`);
                appData = await response.json();
                if (appData.error) throw new Error(appData.error);
                return true;
            } catch (error) { document.getElementById('main-content').innerHTML = `<div class="error card">Failed to connect. Details: ${error.message}</div>`; return false; }
        }

        function renderAllPages() {
            if (!appData) return;
            const { user, settings, tasks, completed_tasks } = appData;
            const userPhoto = telegramUser.photo_url;
            const currency = settings.currency_symbol || 'BDT';

            // --- Header Update ---
            document.getElementById('user-name').textContent = user.first_name;
            document.getElementById('user-balance').textContent = `${parseFloat(user.balance).toFixed(2)} ${currency}`;
            if (userPhoto) document.getElementById('user-avatar').src = userPhoto;

            // --- ✅ HOME PAGE - FULL VERSION ---
            document.getElementById('page-home').innerHTML = `
                <div class="card"><h3>Welcome, ${user.first_name}!</h3><p>A new day brings new opportunities.</p><button class="btn" onclick="navigateTo('earn')">Start Growing</button></div>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div class="card" style="text-align: center;"><span>Total Earnings</span><b style="font-size: 22px; color: var(--primary-color); display: block;">${parseFloat(user.total_earnings).toFixed(2)} ${currency}</b></div>
                    <div class="card" style="text-align: center;"><span>Ads Watched Today</span><b style="font-size: 22px; color: var(--primary-color); display: block;">${user.ads_watched_today}</b></div>
                </div>
                <div class="card" style="position:fixed; bottom:70px; right:20px; padding:0; background:none; box-shadow:none;">
                    <button class="btn" onclick="navigateTo('referral')" style="width:auto; padding:12px 20px; border-radius:50px; box-shadow: 0 4px 12px rgba(0,0,0,0.2);"><i class="fas fa-users"></i>&nbsp; Refer & Earn</button>
                </div>`;

            // --- ✅ EARN PAGE - NEW UI ---
            let tasksHtml = '';
            if (tasks && tasks.length > 0) {
                tasks.forEach(task => {
                    const isCompleted = completed_tasks.includes(task.id);
                    tasksHtml += `
                        <div class="task-item">
                            <div class="task-info"><strong>${task.title}</strong><br><span style="font-size:14px;">${parseFloat(task.reward).toFixed(2)} ${currency}</span></div>
                            <div class="task-actions">
                                ${isCompleted ? '<button class="btn btn-completed" disabled>Verified</button>' : `<a href="${task.link}" target="_blank" class="btn btn-join">Join</a><button class="btn btn-verify">Verify</button>`}
                            </div>
                        </div>`;
                });
            } else {
                tasksHtml = '<p style="text-align:center; color: #888; padding: 20px 0;">No bonus tasks available right now.</p>';
            }
            document.getElementById('page-earn').innerHTML = `
                <div class="card ad-task-card">
                    <h3>Ad Tasks</h3>
                    <p style="color: #757575;">Watch ads to cultivate your earnings.</p>
                    <div style="display: flex; justify-content: space-between; margin: 15px 0; color: #757575;">
                        <span>Completed: <strong>${user.ads_watched_today}</strong></span>
                        <span>Remaining: <strong>${settings.daily_ads_limit - user.ads_watched_today}</strong></span>
                    </div>
                    <button id="watch-ad-btn" class="btn" ${user.ads_watched_today >= settings.daily_ads_limit ? 'disabled' : ''}>
                        <i class="fas fa-play-circle"></i><span id="ad-btn-text">${user.ads_watched_today >= settings.daily_ads_limit ? 'Daily Limit Reached' : 'Watch Ad'}</span>
                    </button>
                </div>
                <div class="card"><h3>Bonus Tasks</h3>${tasksHtml}</div>`;

            // --- ✅ WITHDRAW PAGE - FULL VERSION ---
            document.getElementById('page-withdraw').innerHTML = `
                <div class="card">
                    <h3>Harvest Your Earnings</h3>
                    <p>Available Balance: <b>${parseFloat(user.balance).toFixed(2)} ${currency}</b></p>
                    <form id="withdraw-form" style="margin-top:20px;">
                        <select id="method" name="method" required style="width:100%; padding: 12px; box-sizing: border-box; margin-bottom: 10px; border-radius: 8px; border: 1px solid #ddd;"><option value="">Select a method</option><option>Bkash</option><option>Nagad</option></select>
                        <input type="number" id="amount" name="amount" placeholder="Enter amount" step="0.01" required style="width:100%; padding: 12px; box-sizing: border-box; margin-bottom: 10px; border-radius: 8px; border: 1px solid #ddd;">
                        <input type="text" id="account_number" name="account_number" placeholder="Enter your account number" required style="width:100%; padding: 12px; box-sizing: border-box; margin-bottom: 10px; border-radius: 8px; border: 1px solid #ddd;">
                        <button type="submit" class="btn">Request Withdrawal</button>
                    </form>
                </div>`;

            // --- ✅ PROFILE PAGE - NEW UI ---
            const devUsername = '@DeveloperArifulAS'; // আপনার ডেভেলপার ইউজারনেম
            document.getElementById('page-profile').innerHTML = `
                <div class="card profile-card" style="padding-bottom: 20px;">
                    <img src="${userPhoto || 'https://i.ibb.co/2811g2W/placeholder-avatar.png'}" class="profile-avatar" alt="Avatar">
                    <h2>${user.first_name}</h2>
                    <p style="color: #888; margin-top: -10px; font-weight: 500;">${user.username ? '@' + user.username : 'No public username'}</p>
                    <div class="profile-stats">
                        <div class="stat-item"><i class="fas fa-wallet"></i><div class="info"><span>Balance</span></div><strong class="value">${parseFloat(user.balance).toFixed(2)} ${currency}</strong></div>
                        <div class="stat-item"><i class="fas fa-chart-line"></i><div class="info"><span>Total Earnings</span></div><strong class="value">${parseFloat(user.total_earnings).toFixed(2)} ${currency}</strong></div>
                        <div class="stat-item"><i class="fas fa-eye"></i><div class="info"><span>Ads Watched</span></div><strong class="value">${user.ads_watched_today}</strong></div>
                        <div class="stat-item"><i class="fas fa-users"></i><div class="info"><span>Total Referrals</span></div><strong class="value">${user.total_referrals}</strong></div>
                    </div>
                    <button class="btn contact-btn" onclick="tg.openTelegramLink('https://t.me/${devUsername}')">Contact Developer ${devUsername}</button>
                </div>`;
            
            // --- ✅ REFERRAL PAGE - FLOATING BUTTON on all pages ---
            // The button is now part of the home page. This page can be a dedicated one.
            const refLink = `https://t.me/${settings.bot_username}?start=${telegramUser.id}`;
            document.getElementById('page-referral').innerHTML = `<div class="card" style="text-align:center;"><div style="font-size: 48px;">💌</div><h3>Invite Friends, Earn More!</h3><p style="color:#888;">Share your personal link with friends.</p><div style="padding: 15px; margin: 20px 0; background-color: #eaf2f8; border: 2px dashed #3498db; border-radius: 12px; cursor: pointer;" onclick="navigator.clipboard.writeText('${refLink}'); tg.HapticFeedback.notificationOccurred('success'); tg.showAlert('Link Copied!');"><strong>Click to Copy Your Link</strong><p style="font-size: 14px; color: #3498db; word-break: break-all;">${refLink}</p></div><p>Total Friends Joined: <b>${user.total_referrals}</b></p></div>`;
        }

        window.navigateTo = function(pageName) {
            document.querySelectorAll('.page').forEach(p => p.classList.remove('active'));
            document.getElementById(`page-${pageName}`).classList.add('active');
            document.querySelectorAll('.nav-item').forEach(i => i.classList.toggle('active', i.dataset.page === pageName));
            document.getElementById('app-title').textContent = pageName.charAt(0).toUpperCase() + page.slice(1);
        }

        // --- Ad Handling Logic ---
        document.addEventListener('click', function(e) {
            const watchAdBtn = e.target.closest('#watch-ad-btn');
            if (watchAdBtn && !watchAdBtn.disabled) {
                const adBtnText = document.getElementById('ad-btn-text');
                watchAdBtn.disabled = true;
                adBtnText.textContent = 'Ad Loading...';

                show_10080568().then(() => {
                    adBtnText.textContent = 'Claiming Reward...';
                    fetch(`?action=record_ad_watch&telegram_id=${telegramUser.id}`)
                        .then(response => response.json())
                        .then(result => {
                            if (result.success) {
                                tg.HapticFeedback.notificationOccurred('success');
                                tg.showAlert(result.message);
                                initializeApp(false);
                            } else { /* ... error handling ... */ }
                        });
                }).catch(e => { /* ... error handling ... */ });
            }
        });

        async function initializeApp(showLoading = true) {
            const success = await loadAppData(showLoading);
            if (success) {
                if (showLoading) document.querySelector('.loading.card').style.display = 'none';
                renderAllPages();
                navigateTo('home');
            }
        }
        initializeApp();
    });
    </script>
</body>
</html>